import java.awt.*;

/** A square of the game Checkers */
public class CheckersSquare extends Canvas {

	static public final int EMPTY= 0; 	// Constants used to indicate
	static public final int RED= 1; 	// what is on a square.
	static public final int BLACK= 2; 	// Meaning: obvious
	static public final int REDKING = 3;
	static public final int BLACKKING = 4;

	Rectangle b; 		// Containing rectangle of this square
	int col;			// column number of this square on board
	int row;			// row number of this square on board

	// EMPTY: square is empty;
	// RED (or REDKING) means red piece (red king) is on square;
	// BLACK (or BLACKKING) means black piece (black king) is on square.
		private int fill= EMPTY;

	// = "This square contains the piece to be moved"
	private boolean toBeMoved= false;

				
	/** Constructor: An initially empty square that belongs in
	    column c, row r of the board */
	public CheckersSquare(int c, int r) {
		super();
		col= c;
		row= r;
		if ((c+r)%2 == 1)
	    	setBackground(Color.lightGray);
		else
	    	setBackground((Color.red).brighter());
		setSize(42,42);
		b= getBounds();
		repaint();
	}

	/** Paint the square with its piece (if any), using Graphics g. */
	public void paint (Graphics g) {
		Color save= g.getColor(); // Save the color, to be reset at end
		g.setColor(Color.red);
		g.drawRect(b.x, b.y, b.width-1, b.height-1);
		g.setColor((Color.gray).darker());
    
    	// A checker is drawn as two circles. The first one is offset and
		// smaller, so that when the second is drawn, it covers most of the
		// first except for what appears as a side of the piece.
		// A King has a white ring around it.
		// If toBeMoved is true, highlight this piece by making it
		// a radius of ew=eh=5 bigger than the others
		int ew= 0;
		int eh= 0;
		if (toBeMoved) {
			ew= 5;
			eh= 5;
		}

		if (fill == EMPTY) return;
		// Draw the oval that provides the "side" of the piece
	   		if (fill == RED || fill == REDKING)
	       		g.setColor((Color.red).darker());
	   		else
	       		g.setColor((Color.gray).darker());
	   		g.fillOval(b.x+b.width/4-ew, b.y+b.width/4-ew,b.width/2+ew+ew, b.height/2+ew+ew);
		
		// Draw the top part of the piece
	   		if (fill == RED || fill == REDKING)
	       		 g.setColor(Color.red);
	   		else g.setColor(Color.black);
       		g.fillOval(b.x+b.width/5-ew, b.y+b.width/5-ew, b.width/2+ew+ew, b.height/2+ew+ew);
	
		// If the piece is a king, give it a white ring
			if (fill == REDKING || fill == BLACKKING) {
				g.setColor(Color.white);
	    		g.drawOval(b.x+b.width/6-ew, b.y+b.width/6-ew, b.width/2+ew+ew, b.height/2+ew+ew);
	    		g.drawOval(1+b.x+b.width/6-ew, 1+b.y+b.width/6-ew, b.width/2+ew+ew, b.height/2+ew+ew);
			}
		g.setColor(save);
	}
	
	/** Yield the contents of the square --EMPTY, RED, REDKING, BLACK, or BLACKKING */
	public int contents() {
		return fill;
	} 

	/** Place piece p (RED, REDKING, BLACK, or BLACKKING) in
	    this square (no action if square aleady filled) */
	public void placePiece(int p) {
		if (fill != EMPTY) return;
		fill= p;
		repaint();
		return;
	}
	
	/** return "This square is red" */
	public boolean isRed() {
		return (col+row) % 2 == 0;
	}
	    
	
	/** Pick up the piece (no action if square is empty) */
	public void pickUpPiece() {
		if (fill == EMPTY) return;
		fill= EMPTY;
		repaint();
		return;
	}
	
	/** return "piece on square is red" */
	public boolean containsRed() {
		return (fill==RED) || (fill==REDKING);
	}
	
	/** return "piece on square is black" */
	public boolean containsBlack() {
		return fill==BLACK || fill == BLACKKING;
	}
	
	/** Return "The square contains a king" */
	public boolean isKing() {
		return fill==REDKING || fill==BLACKKING;
	}
	
	/** Set field toBeMoved to b */
	public void setToBeMoved(boolean b) {
		toBeMoved= b;
		repaint();
	}

	
	/** return "square contains piece that is same color as x
    	(which is one of RED, REDKING, BLACK, BLACKKING) */
	public boolean isSameColor(int x) {
		if (fill == EMPTY) return false;
		if ((x == RED || x == REDKING) && containsRed()) return true;
		return ((x == BLACK || x == BLACKKING) && containsBlack());
	}
	
}




